/*
 * * afiseaza texxt de la partener
 * cand primeste '/' sterge afisajul
 * trebuie trecuta adresa MAC a partenerului
 * cu tastatura PS2
 * afiseaza in continuare si text editat local
 * Sterge tot cand se apasa '/'
 * se poate inlocui cu alt simbol
 * */
//https://microcontrollerslab.com/esp32-esp-now-two-way-communication-arduino-ide/
#include <esp_now.h>
#include <WiFi.h>

#include <Adafruit_SSD1306.h>
#include <Adafruit_GFX.h>
#define OLED_ADDR   0x3C
Adafruit_SSD1306 display(-1);

// REPLACE WITH THE MAC Address of your receiver 

//uint8_t broadcastAddress[] = {0xCC, 0x50, 0xE3, 0xB6, 0x51, 0xEC};
//adresa MAC proprie

//uint8_t broadcastAddress[] = {0xCC, 0x50, 0xE3, 0xB6, 0xC7, 0x78};
//adresa MAC3   CC:50:E3:B6:C7:78

uint8_t broadcastAddress[] = {0xCC, 0x50, 0xE3, 0xB6, 0xC4, 0xD4};
//adresa MAC partener  CC:50:E3:B6:C4:D4 

  char w=' ';  //asa citeste textul primit
  
String success;

//Must match the receiver structure
typedef struct struct_message {
    char t;  
    char x;
    
} struct_message;

#include "PS2Keyboard.h"
const int DataPin = 4;  //albastru
const int IRQpin =  0;  //galben
PS2Keyboard keyboard;

struct_message trimite;
struct_message primite;

// Callback when data is sent
void data_sent(const uint8_t *mac_addr, esp_now_send_status_t status) {
  Serial.print("\r\nLast Packet Send Status:\t");
  Serial.println(status == ESP_NOW_SEND_SUCCESS ? "Delivery Success" : "Delivery Fail");
  if (status ==0){
    success = "Delivery Success :)";
  }
  else{
    success = "Delivery Fail :(";
  }
}

// Callback when data is received
void data_receive(const uint8_t * mac, const uint8_t *incomingData, int len) {
  memcpy(&primite, incomingData, sizeof(primite));
  Serial.print("Bytes received: ");
  Serial.println(len);
 //primeste date pe care le atribuie caracterului w
 
  char w=primite.t;
  Serial.print(w);
  display.setTextSize(2);
  display.setTextColor(WHITE);
  
  display.print(w);
  display.display();
  if (w == '/'){//sterge oled cand se tipareste '/'
    display.clearDisplay();
    display.setCursor(0,0);
    }   
   }
 
void setup() {

  Serial.begin(115200);
  
 keyboard.begin(DataPin, IRQpin);
 
  display.begin(SSD1306_SWITCHCAPVCC, OLED_ADDR);
  display.clearDisplay();
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(0,0);
  display.print("P2P Bilat EspNow");
  display.display();
  delay(1000);

 
  WiFi.mode(WIFI_STA);
  if (esp_now_init() != ESP_OK) {
    Serial.println("Error initializing ESP-NOW");
    return;
  }
  esp_now_register_send_cb(data_sent);
  
  esp_now_peer_info_t peerInfo;
  memcpy(peerInfo.peer_addr, broadcastAddress, 6);
  peerInfo.channel = 0;  
  peerInfo.encrypt = false;       
  if (esp_now_add_peer(&peerInfo) != ESP_OK){
    Serial.println("Failed to add peer");
    return;
  }
  // Register for a callback function that will be called when data is received
  esp_now_register_recv_cb(data_receive);
}
 
void loop() {

  if (keyboard.available()) {
    
    char c = keyboard.read(); 
    //citeste caractere tastatura locala 

   //afiseaza caractere tastatura locala 
   
  display.setTextSize(2);
  display.setTextColor(WHITE);
  
  display.print(c);
  display.display();
  if (c == '/'){//sterge oled cand se tipareste '/'
    //se poate alege orice caracter pentru sters local
    display.clearDisplay();
    display.setCursor(0,0);
    }   
    
  trimite.x = c; 
  //trimite datele de la tastatura cu indexul x
  esp_err_t result = esp_now_send(broadcastAddress, (uint8_t *) &trimite, sizeof(trimite));
     
  if (result == ESP_OK) {
    Serial.println("Sent with success");
  }
  else {
    Serial.println("Error sending the data");
  }  
  }
  }
